/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import cds.aladin.stc.STCStringParser;
import cds.tools.Util;
import java.util.ArrayList;
import java.util.List;

public class HealpixProgenItem {
    private String json;
    private List<STCObj> stcObjects = null;
    private boolean stcError = false;
    static final char SEP = Util.FS.charAt(0);
    private long ovIZ;
    private PointD[] viewCorners;
    private Coord[] corners;
    private int nNull;
    private boolean computeCorners;

    public HealpixProgenItem(String s) {
        this.json = s;
    }

    public String getJson() {
        return this.json;
    }

    public String getID() {
        return this.getPath();
    }

    public String getPath() {
        int first = -1;
        String path = Util.extractJSON("path", this.json);
        if (path == null) {
            path = this.json;
        }
        if (path.charAt(path.length() - 1) == ']') {
            first = path.lastIndexOf(91);
        }
        String s = path;
        if (first > 0) {
            s = path.substring(0, first);
            int mef = path.lastIndexOf(58);
            if (mef > first) {
                s = path.substring(0, mef) + "]";
            }
        }
        return s;
    }

    public String getSTC() {
        return Util.extractJSON("stc", this.json);
    }

    public List<STCObj> getSTCObj() {
        if (this.stcError) {
            return null;
        }
        if (this.stcObjects == null) {
            try {
                this.stcObjects = new STCStringParser().parse(this.getSTC());
            }
            catch (Exception e) {
                this.stcError = true;
                return null;
            }
        }
        return this.stcObjects;
    }

    public Coord[] getCorners() {
        if (!this.computeCorners) {
            this.corners = this.computeCorners();
        }
        return this.corners;
    }

    private Coord[] computeCorners() {
        this.computeCorners = true;
        List<STCObj> list = this.getSTCObj();
        if (list == null) {
            return null;
        }
        int n = 0;
        for (STCObj obj : list) {
            if (!(obj instanceof STCPolygon)) continue;
            n += ((STCPolygon)obj).getxCorners().size();
            break;
        }
        Coord[] coo = new Coord[n];
        int i = 0;
        for (STCObj obj : list) {
            if (!(obj instanceof STCPolygon)) continue;
            ArrayList<Double> x = ((STCPolygon)obj).getxCorners();
            ArrayList<Double> y = ((STCPolygon)obj).getyCorners();
            int m = x.size();
            for (int j = 0; j < m; ++j) {
                coo[i++] = new Coord(x.get(j), y.get(j));
            }
        }
        return coo;
    }

    private PointD[] getProjViewCorners(ViewSimple v) {
        int i;
        long vIZ = v.getIZ();
        if (this.ovIZ == vIZ) {
            if (this.nNull > 1) {
                return null;
            }
            return this.viewCorners;
        }
        Projection proj = v.getProj();
        Coord[] corners = this.getCorners();
        if (proj == null || corners == null) {
            return null;
        }
        this.nNull = 0;
        if (this.viewCorners == null) {
            this.viewCorners = new PointD[corners.length];
        }
        for (i = 0; i < corners.length; ++i) {
            Coord c = corners[i];
            proj.getXY(c);
            if (Double.isNaN(c.x)) {
                ++this.nNull;
                if (this.nNull > 1) {
                    return null;
                }
                this.viewCorners[i] = null;
                continue;
            }
            if (this.viewCorners[i] == null) {
                this.viewCorners[i] = new PointD(c.x, c.y);
                continue;
            }
            this.viewCorners[i].x = c.x;
            this.viewCorners[i].y = c.y;
        }
        for (i = 0; i < corners.length; ++i) {
            if (this.viewCorners[i] == null) continue;
            v.getViewCoordDble(this.viewCorners[i], this.viewCorners[i].x, this.viewCorners[i].y);
        }
        this.ovIZ = vIZ;
        return this.viewCorners;
    }

    public boolean isOutView(ViewSimple v) {
        double maxY;
        double maxX;
        if (v.isAllSky()) {
            return false;
        }
        int w = v.getWidth();
        int h = v.getHeight();
        PointD[] b = this.getProjViewCorners(v);
        if (b == null) {
            return false;
        }
        double minX = maxX = b[0].x;
        double minY = maxY = b[0].y;
        for (int i = 1; i < b.length; ++i) {
            if (b[i].x < minX) {
                minX = b[i].x;
            } else if (b[i].x > maxX) {
                maxX = b[i].x;
            }
            if (b[i].y < minY) {
                minY = b[i].y;
                continue;
            }
            if (!(b[i].y > maxY)) continue;
            maxY = b[i].y;
        }
        if (minX < 0.0 && maxX < 0.0 || minX >= (double)w && maxX >= (double)w) {
            return true;
        }
        return minY < 0.0 && maxY < 0.0 || minY >= (double)h && maxY >= (double)h;
    }
}

